<?php
include "includes/header.php";
?>
<?php
try {
    $db = new SQLite3(__DIR__ . '/api/.dbmaxrebrands.db');
} catch (Exception $e) {
    echo "Erro: " . $e->getMessage();
}

// Verifica se o formulário foi enviado e a URL foi inserida
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['video_url'])) {
    $videoUrl = $_POST['video_url'];

    // Preparar e executar a consulta para inserir a URL na tabela intro
    $stmt = $db->prepare("INSERT INTO intro (url) VALUES (:url)");
    $stmt->bindValue(':url', $videoUrl, SQLITE3_TEXT);
    if ($stmt->execute()) {
        echo "<script>alert('URL do vídeo inserida com sucesso!');</script>";
    } else {
        echo "<script>alert('Erro ao inserir a URL.');</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Configurar Vídeo de Introdução</title>
  <!-- Font Awesome para ícones -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --primary-color: #4361ee;
      --secondary-color: #3f37c9;
      --success-color: #4cc9f0;
      --light-color: #f8f9fa;
      --dark-color: #212529;
      --border-radius: 8px;
      --box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
      --transition: all 0.3s ease;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background-color: #f5f7ff;
      color: var(--dark-color);
      line-height: 1.6;
      padding: 0;
      margin: 0;
    }
    
    .upload-container {
      max-width: 800px;
      margin: 40px auto;
      padding: 30px;
      background-color: white;
      border-radius: var(--border-radius);
      box-shadow: var(--box-shadow);
      transition: var(--transition);
    }
    
    .upload-container:hover {
      box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }
    
    .page-title {
      text-align: center;
      color: var(--primary-color);
      margin-bottom: 30px;
      font-weight: 600;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
      font-size: 1.8rem;
      margin-top: 0.5rem;
    }
    
    .input-wrap {
      margin-bottom: 25px;
    }
    
    .input-wrap label {
      display: block;
      margin-bottom: 8px;
      font-weight: 500;
      color: var(--dark-color);
    }
    
    .input-wrap input {
      width: 100%;
      padding: 12px 15px;
      border: 2px solid #e0e0e0;
      border-radius: var(--border-radius);
      font-size: 16px;
      transition: var(--transition);
      padding-left: 40px;
    }
    
    .input-wrap input:focus {
      border-color: var(--primary-color);
      outline: none;
      box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
    }
    
    .input-icon {
      position: relative;
    }
    
    .input-icon i {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #6c757d;
    }
    
    .confirm-button {
      width: 100%;
      padding: 12px;
      font-size: 16px;
      font-weight: 600;
      background-color: var(--primary-color);
      color: white;
      border: none;
      border-radius: var(--border-radius);
      cursor: pointer;
      transition: var(--transition);
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
    }
    
    .confirm-button:hover {
      background-color: var(--secondary-color);
      transform: translateY(-2px);
    }
    
    .confirm-button:active {
      transform: translateY(0);
    }
    
    #videoPreviewContainer {
      margin: 25px 0;
      display: none;
      border-radius: var(--border-radius);
      overflow: hidden;
      box-shadow: var(--box-shadow);
    }
    
    #videoPreview {
      width: 100%;
      display: block;
    }
    
    .instructions {
      background-color: #f8f9fa;
      padding: 15px;
      border-radius: var(--border-radius);
      margin-bottom: 20px;
      border-left: 4px solid var(--primary-color);
    }
    
    .instructions h3 {
      margin-top: 0;
      color: var(--primary-color);
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .instructions ul {
      padding-left: 20px;
      margin-bottom: 0;
    }
    
    .instructions li {
      margin-bottom: 8px;
    }
    
    .progress-container {
      margin-top: 20px;
      display: none;
    }
    
    .progress-label {
      display: flex;
      justify-content: space-between;
      margin-bottom: 5px;
      font-size: 14px;
    }
    
    #progressBar {
      height: 10px;
      background-color: #e9ecef;
      border-radius: 5px;
      overflow: hidden;
    }
    
    #progressBar div {
      height: 100%;
      background-color: var(--primary-color);
      width: 0%;
      transition: width 0.3s ease;
    }
    
    @media (max-width: 768px) {
      .upload-container {
        margin: 20px;
        padding: 20px;
      }
    }
  </style>
</head>
<body>
  <div class="upload-container">
    <h1 class="page-title">
      <i class="fas fa-video"></i> Vídeo de Introdução
    </h1>
    
    <div class="instructions">
      <h3><i class="fas fa-info-circle"></i> Instruções</h3>
      <ul>
        <li>Cole a URL do vídeo que deseja usar como introdução</li>
        <li>Suporta links do YouTube, Vimeo e DailyMotion</li>
        <li>O vídeo será exibido automaticamente em seu site</li>
      </ul>
    </div>
    
    <form method="POST">
      <div class="input-wrap">
        <label for="video_url">URL do Vídeo</label>
        <div class="input-icon">
          <i class="fas fa-link"></i>
          <input type="text" id="video_url" name="video_url" placeholder="https://www.youtube.com/watch?v=..." required>
        </div>
      </div>

      <!-- Espaço para o preview do vídeo -->
      <div id="videoPreviewContainer">
        <h3><i class="fas fa-play-circle"></i> Pré-visualização</h3>
        <video id="videoPreview" controls></video>
      </div>

      <button type="submit" class="confirm-button">
        <i class="fas fa-save"></i> Salvar URL
      </button>
    </form>

    <!-- Barra de progresso -->
    <div class="progress-container" id="progressWrapper">
      <div class="progress-label">
        <span>Progresso</span>
        <span id="progressCount">0%</span>
      </div>
      <div id="progressBar"><div></div></div>
    </div>
  </div>

  <script>
    // Função para exibir o preview do vídeo com base na URL inserida
    document.getElementById('video_url').addEventListener('input', function() {
      const videoUrl = this.value.trim();
      const videoPreview = document.getElementById('videoPreview');
      const videoPreviewContainer = document.getElementById('videoPreviewContainer');
      
      // Verifica se a URL inserida parece válida para um vídeo
      const validUrlPattern = /^(https?:\/\/)?(www\.)?(youtube|vimeo|dailymotion)\.(com|tv|net)\/.*/;
      if (videoUrl && validUrlPattern.test(videoUrl)) {
        // Se for YouTube, converter para embed
        if (videoUrl.includes('youtube.com') || videoUrl.includes('youtu.be')) {
          let embedUrl = videoUrl
            .replace(/(https?:\/\/)?(www\.)?youtube\.com\/watch\?v=/, 'https://www.youtube.com/embed/')
            .replace(/(https?:\/\/)?(www\.)?youtu\.be\//, 'https://www.youtube.com/embed/')
            .split('&')[0];
          
          videoPreview.src = embedUrl;
        } else {
          videoPreview.src = videoUrl;
        }
        
        videoPreviewContainer.style.display = 'block';
      } else {
        videoPreviewContainer.style.display = 'none';
      }
    });
    
    // Simular progresso (pode ser removido ou adaptado conforme necessidade)
    document.querySelector('form').addEventListener('submit', function() {
      const progressWrapper = document.getElementById('progressWrapper');
      const progressBar = document.querySelector('#progressBar div');
      const progressCount = document.getElementById('progressCount');
      
      progressWrapper.style.display = 'block';
      
      let progress = 0;
      const interval = setInterval(() => {
        progress += 5;
        progressBar.style.width = progress + '%';
        progressCount.textContent = progress + '%';
        
        if (progress >= 100) {
          clearInterval(interval);
        }
      }, 100);
    });
  </script>
</body>
</html>

<?php
// Incluindo o rodapé
?>